//----------------------------------------------------------------------------//
//- CafArtikel.pas -----------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Frame, das Eingabefelder fr die Artikeldaten zur Verfgung stellt         //
//----------------------------------------------------------------------------//

unit CafArtikel;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses 
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CaoCheck, CaoArtikelListe;

//------------------------------------------------------------------------------

type
  TFrmArtikeldaten = class(TFrame)
    m_LblBezeichnung  : TLabel;
    m_EdtBezeichnung  : TEdit;
    m_lblPreis        : TLabel;
    m_EdtPreis        : TEdit;

    //--------------------------------------------------------------------------

    procedure EdtPreisChange(Sender: TObject);

  //----------------------------------------------------------------------------

  private
    m_obCaoCheck: TCaoCheck;
    m_obArtikel : TCaoArtikel;

  //----------------------------------------------------------------------------

  public
    procedure CreateFrame;
    procedure DestroyFrame;
    procedure ShowFrame(var obArtikel: TCaoArtikel);
    procedure CloseFrame;

  //----------------------------------------------------------------------------

  end; //  TFrmArtikeldaten

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

procedure TFrmArtikeldaten.CreateFrame;
begin
  m_obCaoCheck := TCaoCheck.Create;
end; // TFrmArtikeldaten.CreateFrame

//------------------------------------------------------------------------------

procedure TFrmArtikeldaten.DestroyFrame;
begin
  m_obCaoCheck.Free;
end; // TFrmArtikeldaten.DestroyFrame

//------------------------------------------------------------------------------

procedure TFrmArtikeldaten.EdtPreisChange(Sender: TObject);
begin
  m_obCaoCheck.EditWithNumbers(m_EdtPreis, True);
end; // TFrmArtikeldaten.EdtPreisChange

//------------------------------------------------------------------------------

procedure TFrmArtikeldaten.ShowFrame(var obArtikel: TCaoArtikel);
(*
  Laden der Daten
*)
begin
  m_EdtBezeichnung.SetFocus;
  m_obArtikel           := obArtikel;
  m_EdtBezeichnung.Text := obArtikel.sBeschreibung;
  if obArtikel.dPreis >= 0.1 then begin
    m_EdtPreis.Text       := FloatToStr(obArtikel.dPreis);
  end // if
  else begin
    m_EdtPreis.Text := '';
  end; // else
end; // TFrmArtikeldaten.InitFrame

//------------------------------------------------------------------------------

procedure TFrmArtikeldaten.CloseFrame;
begin
  m_obArtikel.sBeschreibung      := m_EdtBezeichnung.Text;
  m_obArtikel.dPreis             := StrToFloat(m_EdtPreis.Text);
end; // TFrmArtikeldaten.CloseFrame

//------------------------------------------------------------------------------

end. // CafArtikel
